﻿using Microsoft.AspNetCore.Mvc;
using RemiseANiveau2.Models;
using RemiseANiveau2.Repository.Contracts;

namespace RemiseANiveau2.Controllers
{
    /// <summary>
    /// MenuRapportController pour les entités de type Version
    /// </summary>
    public class VersionController : Controller
    {
        private IVersionRepository versionRepository;

        // <summary>
        /// Initialise une nouvelle instance du contrôleur avec le dépôt spécifié.
        /// </summary>
        /// <param name="versionRepository">Le dépôt des versions.</param>
        public VersionController(IVersionRepository versionRepository)
        {
            this.versionRepository = versionRepository;
        }

        /// <summary>
        /// Affiche la page d'index.
        /// </summary>
        /// <returns>Page d'accueil</returns>
        public ActionResult Index()
        {
            var model = new VersionIndexViewModel()
            {
                Versions = this.versionRepository.FindAll(),
                Count = this.versionRepository.Count(),
                Premier = this.versionRepository.First().Numero,
                Last = this.versionRepository.Last().Numero,
                Après5eme = this.versionRepository.Après5eme(),
                OrderByNum = this.versionRepository.OrderByNum(),
                OrderBy = this.versionRepository.OrderBy(),
                Anon = this.versionRepository.Anon()

            };

            return View(model);
        }
        public ActionResult Exercices()
        {
            var model = new VersionExercicesViewModel()
            {
                Count = this.versionRepository.Count(),
                Premier = this.versionRepository.First().Numero,
                Last = this.versionRepository.Last().Numero,
                Après5eme = this.versionRepository.Après5eme(),
                OrderByNum = this.versionRepository.OrderByNum(),
                OrderBy = this.versionRepository.OrderBy(),
                Anon = this.versionRepository.Anon()
            };

            return View(model);
        }

        /// <summary>
        /// Affiche la page d'ajout de version.
        /// </summary>
        /// <returns>la vue de cette action</returns>
        public ActionResult Add()
        {
            return View(new VersionEditViewModel());
        }

        /// <summary>
        /// Action visant à ajouter une version en fonction du numéro fournis.
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        [HttpPost]
        public ActionResult Add(VersionEditViewModel model)
        {
            string NumVersion = model.NumVersion;
            string Date = DateTime.Now.ToString();

            if (NumVersion != null && NumVersion.Length < 5 && NumVersion.Length > 0)
            {

                this.versionRepository.Add(new Entities.Version(Date, NumVersion));


            }
            else
            {
                TempData["Message"] = "Une version ne peut pas dépasser 5 caractères ni être nulle";
            }

            if (NumVersion != null && NumVersion.Length < 5 && NumVersion.Length > 0)
            {
                return RedirectToAction("Index");
            }
            else
            {
                return RedirectToAction("Add");
            }
        }

        /// <summary>
        /// Action visant à supprimer une version en fonction du numéro fourni.
        /// </summary>
        /// <param name="Numero"></param>
        /// <returns></returns>
        [HttpPost]
        public ActionResult DeleteVersion(string Numero, string Date)
        {
            Entities.Version VersionAEnlever = new(Date, Numero);

            if (VersionAEnlever != null)
            {
                versionRepository.Remove(VersionAEnlever);
                TempData["Message"] = "Hop supprimée.";
            }

            return RedirectToAction("Index");
        }
    }
}
